// connectionplayer
// oswald berthold 10/2007
// plays sounds correlating to network connections


// init
(
Server.default = s = Server.local;
s.boot;
g = SwingOSC.default;
g.boot;
)

(

~hostaction = {
	|t,r,m|
	var ip = m[1].asString.split($.);
	ip.postln;
	m.postln;
	Synth(\host1, [
		\a1, ip[0].asInteger,
		\a2, ip[1].asInteger,
		\a3, ip[2].asInteger,
		\a4, ip[3].asInteger, \localflag]);
};

~hostresp = OSCresponder(nil, "/host", ~hostaction).add;
~newhostresp = OSCresponder(nil, "/new/host", ~hostaction).add;

~connaction = {
	|t,r,m|
	var sip = m[1].asString.split($.);
	var dip = m[3].asString.split($.);
	[sip, dip].postln;
	Synth(\conn1, [
		\s1, sip[0].asInteger, \s2, sip[1].asInteger, \s3, sip[2].asInteger, \s4, sip[3].asInteger, \sport, m[2]/65535,
		\d1, dip[0].asInteger, \d2, dip[1].asInteger, \d3, dip[2].asInteger, \d4, dip[3].asInteger, \dport, m[4]/65535,
		\proto, m[5]
	]);
	// XXX: wenn viele pakete, lautstaerke runter
};

~connresp = OSCresponder(nil, "/connection", ~connaction).add;
~newconnresp = OSCresponder(nil, "/new/connection",	~connaction).add;

~delaction = {
	|t,r,m|
	m.postln;
};

~delconnresp = OSCresponder(nil, "/delete/connection", ~delaction).add;
~delhostresp = OSCresponder(nil, "/delete/host", ~delction).add;
)

(
~hostresp.remove;
~newhostresp.remove;
~connresp.remove;
~newconnresp.remove;
~delconnresp.remove;
~delhostresp.remove;
)

// synths
(
SynthDef(\host1, {
	|a1(0), a2(0), a3(0), a4(0), localflag(0)|
	var fscale = 2;
	var snd = Mix([
		SinOsc.ar(a1 * fscale, 0, 0.1),
		SinOsc.ar(a2 * fscale, 0, 0.1),
		SinOsc.ar(a3 * fscale, 0, 0.1),
		SinOsc.ar(a4 * fscale, 0, 0.1),
	]);
	Out.ar(0, Pan2.ar(snd * Linen.kr(Impulse.ar(0), 0.001, 1.0, 0.1, doneAction: 2), 0));
}).send(s);

SynthDef(\conn1, {
	|s1, s2, s3, s4, sport, d1, d2, d3, d4, dport, proto|
	// ports: 123, 1194
	var fscale = 10;
	var foffs = 0;
	var len = 0.6;
	var mod = SinOsc.ar(Line.ar(sport, dport, len, 100, 0), 0, 100);
	var snd = Mix([
		SinOsc.ar(Line.ar(s1, d1, len, mul: fscale, add: foffs) + mod, 0, 0.02),
		SinOsc.ar(Line.ar(s2, d2, len, mul: fscale, add: foffs) + mod, 0, 0.02),
		SinOsc.ar(Line.ar(s3, d3, len, mul: fscale, add: foffs) + mod, 0, 0.02),
		SinOsc.ar(Line.ar(s4, d4, len, mul: fscale, add: foffs) + mod, 0, 0.02),
	]);
	Out.ar(0, Pan2.ar(snd * Linen.kr(Impulse.ar(0), 0.001, 1.0, len - 0.001, doneAction: 2), 0));
}).send(s);

// XXX
// icons fuer bekannte services
)

Synth(\host1, [\a1, 100, \a2, 200, \a3, 300, \a4, 400]);

(
Synth(\conn1, [
	\s1, 100, \s2, 200, \s3, 150, \s4, 50, \sport, 1000,
	\d1, 200, \d2, 100, \d3, 50, \d4, 159 , \dport, 8000,
	\proto, 6
]);
)
